package com.testor.module.threeframework.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;


/**
 * 三同时管理附件对象 t_three_time_auxiliary
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_three_time_auxiliary")
@ApiModel(value = "TThreeTimeAuxiliary对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TThreeTimeAuxiliary extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 批复时间
     */
    @ApiModelProperty(value = "批复时间")

    @TableField("reply_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date replyDate;
    /**
     * 附件
     */
    @ApiModelProperty(value = "附件")

    @TableField("accessory")
    private String accessory;
    /**
     * 项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）
     */
    @ApiModelProperty(value = "项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）")

    @TableField("plan")
    private String plan;
    /**
     * 附件类型（例：评价报告、附件及批复文件：safetyEvaluation），其他相关资料传入：rests
     */
    @ApiModelProperty(value = "附件类型（例：评价报告、附件及批复文件：safetyEvaluation），其他相关资料传入：rests")

    @TableField("type")
    private String type;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String REPLY_DATE = "reply_date";
    public static final String ACCESSORY = "accessory";
    public static final String PLAN = "plan";
    public static final String TYPE = "type";


}
