/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.security;

import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.codec.Base64Helper;
import com.tongtech.tfw.backend.core.helper.security.sm4.SM4;
import com.tongtech.tfw.backend.core.helper.security.sm4.SM4_Context;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sm4Helper {
    private static final String secretKeyDefault = "c8e8e733ac8c4043a1d6464ae82d70e6";
    private static final String ivDefault = "31313131313131313131313131313131";
    private static final boolean hexStringDefault = true;
    private static final Pattern p = Pattern.compile("\\s*|\t|\r|\n");

    public static String encryptData_ECB(String plainText) {
        return Sm4Helper.encryptData_ECB(plainText, secretKeyDefault, true);
    }

    public static String encryptData_ECB(String plainText, String secretKey, boolean hexString) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = hexString ? TypeHelper.hexStringToBytes(secretKey) : TypeHelper.hexStringToBytes(secretKey);
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes(StandardCharsets.UTF_8));
            return TypeHelper.byteToHex(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptData_ECB(String cipherText) {
        return Sm4Helper.decryptData_ECB(cipherText, secretKeyDefault, true);
    }

    public static String decryptData_ECB(String cipherText, String secretKey, boolean hexString) {
        try {
            byte[] encrypted = TypeHelper.hexToByte(cipherText);
            cipherText = Base64Helper.encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = hexString ? TypeHelper.hexStringToBytes(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64Helper.decode(cipherText));
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptData_CBC(String plainText) {
        return Sm4Helper.encryptData_CBC(plainText, secretKeyDefault, true, ivDefault);
    }

    public static String encryptData_CBC(String plainText, String secretKey, boolean hexString, String iv) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (hexString) {
                keyBytes = TypeHelper.hexStringToBytes(secretKey);
                ivBytes = TypeHelper.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes(StandardCharsets.UTF_8));
            return TypeHelper.byteToHex(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptData_CBC(String cipherText) {
        return Sm4Helper.decryptData_CBC(cipherText, secretKeyDefault, true, ivDefault);
    }

    public static String decryptData_CBC(String cipherText, String secretKey, boolean hexString, String iv) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            byte[] encrypted = TypeHelper.hexToByte(cipherText);
            cipherText = Base64Helper.encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (hexString) {
                keyBytes = TypeHelper.hexStringToBytes(secretKey);
                ivBytes = TypeHelper.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64Helper.decode(cipherText));
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String plainText = "I Love You Every Day";
        String s = TypeHelper.byteToHex(plainText.getBytes());
        System.out.println("\u539f\u6587" + s);
        System.out.println("ECB\u6a21\u5f0f\u52a0\u5bc6");
        String cipherText = Sm4Helper.encryptData_ECB(plainText);
        System.out.println("\u5bc6\u6587: " + cipherText);
        System.out.println();
        String plainText2 = Sm4Helper.decryptData_ECB(cipherText);
        System.out.println("\u660e\u6587: " + plainText2);
        System.out.println();
        System.out.println("CBC\u6a21\u5f0f\u52a0\u5bc6");
        String cipherText2 = Sm4Helper.encryptData_CBC(plainText);
        System.out.println("\u52a0\u5bc6\u5bc6\u6587: " + cipherText2);
        System.out.println();
        String plainText3 = Sm4Helper.decryptData_CBC(cipherText2);
        System.out.println("\u89e3\u5bc6\u660e\u6587: " + plainText3);
    }
}

