/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.net.openssl;

import com.tongweb.web.jni.SSLContext;
import com.tongweb.web.util.net.openssl.OpenSSLContext;
import com.tongweb.web.util.net.openssl.OpenSSLSessionStats;
import com.tongweb.web.util.res.StringManager;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

public class OpenSSLSessionContext
implements SSLSessionContext {
    private static final StringManager sm = StringManager.getManager(OpenSSLSessionContext.class);
    private static final Enumeration<byte[]> EMPTY = new EmptyEnumeration();
    private final OpenSSLSessionStats stats;
    private final OpenSSLContext context;
    private final long contextID;

    OpenSSLSessionContext(OpenSSLContext context) {
        this.context = context;
        this.contextID = context.getSSLContextID();
        this.stats = new OpenSSLSessionStats(this.contextID);
    }

    @Override
    public SSLSession getSession(byte[] bytes) {
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return EMPTY;
    }

    public void setTicketKeys(byte[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException(sm.getString("sessionContext.nullTicketKeys"));
        }
        SSLContext.setSessionTicketKeys(this.contextID, keys);
    }

    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? 2L : 0L;
        SSLContext.setSessionCacheMode(this.contextID, mode);
    }

    public boolean isSessionCacheEnabled() {
        return SSLContext.getSessionCacheMode(this.contextID) == 2L;
    }

    public OpenSSLSessionStats stats() {
        return this.stats;
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheTimeout(this.contextID, seconds);
    }

    @Override
    public int getSessionTimeout() {
        return (int)SSLContext.getSessionCacheTimeout(this.contextID);
    }

    @Override
    public void setSessionCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheSize(this.contextID, size);
    }

    @Override
    public int getSessionCacheSize() {
        return (int)SSLContext.getSessionCacheSize(this.contextID);
    }

    public boolean setSessionIdContext(byte[] sidCtx) {
        return SSLContext.setSessionIdContext(this.contextID, sidCtx);
    }

    private static final class EmptyEnumeration
    implements Enumeration<byte[]> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public byte[] nextElement() {
            throw new NoSuchElementException();
        }
    }
}

