package com.testor.ddd.safetyControl.domain.lecls.entity;

import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.TSafeRiskLeclsConfDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.TSafeRiskLeclsConfDTOParam;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeRiskLeclsConfRepo {

    TSafeRiskLeclsConfDTO insert(TSafeRiskLeclsConfDTO riskLeclsConfDTO);

    TSafeRiskLeclsConfDTO updateById(TSafeRiskLeclsConfDTO riskLeclsConfDTO);

    TSafeRiskLeclsConfDTO findById(String id);

    boolean deleteById(String id);

    List<TSafeRiskLeclsConfDTO> listAllEntity(TSafeRiskLeclsConfDTOParam param);

    List<TSafeRiskLeclsConfDTO> saveOrUpdateBatch(List<TSafeRiskLeclsConfDTO> riskLeclsConfDTOList);

//    TSafeRiskLeclsConfDTO saveOrUpdate(TSafeRiskLeclsConfDTO riskLeclsConfDTOList);

    /**
     * 检测 编码 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeRiskLeclsConfDTO> checkUniqueness(String leclsConfId, Integer type, String code);

}
