package com.testor.ddd.safetyControl.domain.riskSource.service.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.domain.riskSource.entity.TSafeRiskSourceRepo;
import com.testor.ddd.safetyControl.domain.riskSource.service.RiskSourceService;
import com.testor.ddd.safetyControl.infrastructure.uitls.IsMajorEnum;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class RiskSourceServiceImpl implements RiskSourceService {

    @Resource
    private TSafeRiskSourceRepo riskSourceRepo;


    /**
     * 编辑空间
     *
     * @param riskSourceDto
     * @return
     */
    public BaseResponse<TSafeRiskSourceDTO> editRiskSource(String userId, String orgId, TSafeRiskSourceDTO riskSourceDto) {
        BaseResponse baseResponse = new BaseResponse<>();

        // 重大危险源 与 危险等级的关系处理
        if(IsMajorEnum.yes.getCode().equals(riskSourceDto.getIsMajor())) {
            if(StrUtil.isBlank(riskSourceDto.getRiskLevelId())) {
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                baseResponse.setMsg("该数据为重大危险源，请选择危险等级！");
                return baseResponse;
            }
        } else if(!StrUtil.isBlank(riskSourceDto.getRiskLevelId())){
            riskSourceDto.setRiskLevelId(null);
        }

        boolean checkResult = checkUniqueness(orgId, riskSourceDto.getId(), riskSourceDto.getName());
        if (!checkResult) {
            baseResponse.setCode(BaseStatusEnum.UNKNOWN.code());
            baseResponse.setMsg("已存在相同名称的数据");
            return baseResponse;
        }

        String dataId = riskSourceDto.getId();
        if (StrUtil.isBlank(dataId)) { // 新增
            riskSourceDto.setUpdated("0");
            riskSourceDto.setCreateBy(userId);
            riskSourceDto.setOrgId(orgId);
            riskSourceDto = riskSourceRepo.insert(riskSourceDto);
            baseResponse.setData(riskSourceDto);
            return baseResponse;
        }

        if (!orgId.equals(riskSourceDto.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("当前用户无法操作该条数据");
            return baseResponse;
        }
        riskSourceDto.setUpdated("1");
        riskSourceDto.setUpdateBy(userId);
        riskSourceDto =riskSourceRepo.updateById(riskSourceDto);
        baseResponse.setData(riskSourceDto);
        return baseResponse;
    }

    public BaseResponseList<TSafeRiskSourceVO> listByPage(TSafeRiskSourceDTOParam param){
        BaseResponseList<TSafeRiskSourceVO> baseResponseList=new BaseResponseList<>();
        baseResponseList = riskSourceRepo.listPage(param);
        return baseResponseList;
    }

    public TSafeRiskSourceDTO findById(String id){
        return riskSourceRepo.findById(id);
    }

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    public boolean checkUniqueness(String orgId, String sourceId, String name){
        List<TSafeRiskSourceDTO> sourceDTOList = riskSourceRepo.checkUniqueness(orgId, sourceId, name);
        if(sourceDTOList == null || sourceDTOList.size() == 0) {
            return true;
        }
        return false;
    }

    @Override
    public List<TSafeRiskSourceVO> listExpData(TSafeRiskSourceDTOParam param) {
        return riskSourceRepo.listExpData(param);
    }
}
