package com.testor.ddd.safetyControl.infrastructure.repository.riskPointSource.service;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.testor.ddd.safetyControl.domain.riskPointSource.entity.TSafeRiskPointSourceRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskPointSource.dao.TSafeRiskPointSourceDao;
import com.testor.ddd.safetyControl.infrastructure.repository.riskPointSource.entity.TSafeRiskPointSourceDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPointSource.TSafeRiskPointSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPointSource.TSafeRiskPointSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.RiskPointSourceVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 风险点-危险源关联关系Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-20 14:18:13
 */
@Service
public class TSafeRiskPointSourceServiceImpl extends SuperServiceImpl<TSafeRiskPointSourceDao, TSafeRiskPointSourceDO> implements TSafeRiskPointSourceRepo
{
    @Autowired(required = false)
    private TSafeRiskPointSourceDao tSafeRiskPointSourceDao;

    public boolean deleteByPointId(String pointId){
        UpdateWrapper<TSafeRiskPointSourceDO> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeRiskPointSourceDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskPointSourceDO::getStatus, BizConstants.STATUS_DELETE)
                .eq(TSafeRiskPointSourceDO::getPointId,pointId);
        return update(updateWrapper);
    }

    public List<RiskPointSourceVO> listAll(TSafeRiskPointSourceDTOParam param){
        List<RiskPointSourceVO> resultList=tSafeRiskPointSourceDao.listAll(param);
        return resultList;
    }

    
    public boolean saveBatch(List<TSafeRiskPointSourceDTO> riskPointSourceDTOList){
        List<TSafeRiskPointSourceDO> riskPointDOList = BeanHelper.listToList(riskPointSourceDTOList, TSafeRiskPointSourceDO.class);
        return saveBatch(riskPointDOList);
    }

}
