package com.testor.module.contractor.ledger.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.core.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@Data
public class TContractorToolsExcelDto {
    /**
     * 工器具名称
     */
    @ApiModelProperty(value = "工器具名称")
    @Excel(name = "工器具名称")
    private String toolsName;

    /**
     * 类别id（数据字典id）
     */
    @ApiModelProperty(value = "类别id（数据字典id）")
    @Excel(name = "类别")
    private String type;

    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    @Excel(name = "型号")
    private String model;

    /**
     * 数量
     */
    @ApiModelProperty(value = "数量" , example = "0")
    @Excel(name = "数量",cellType = Excel.ColumnType.NUMERIC, defaultValue = "0")
    private Long num;
    /**
     * 用途
     */
    @ApiModelProperty(value = "用途")
    @Excel(name = "用途")
    private String purpose;

    /**
     * 检查情况 0未检查 1已检查
     */
    @ApiModelProperty(value = "检查情况 0未检查 1已检查")
    @Excel(name = "检查情况",readConverterExp = "0=未检查,1=已检查",combo = {"未检查","已检查"})
    private String checkStatus;

    /**
     * 检查日期
     */
    @ApiModelProperty(value = "检查日期")
    @Excel(name = "检查日期",dateFormat = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date checkTime;

    /**
     * 是否合格 0 不合格 1 合格
     */
    @ApiModelProperty(value = "是否合格 0 不合格 1 合格")
    @Excel(name = "是否合格",readConverterExp = "0=不合格,1=合格",combo = {"不合格","合格"})
    private String isPass;

    @ApiModelProperty("备注")
    @Excel(name = "备注")
    private String remarks;
}
