package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;

import com.testor.module.contractor.ledger.model.domain.TContractorMaterial;
import com.testor.module.contractor.ledger.model.domain.TContractorProtectiveEquipment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 准入信息-物料台账关联对象 t_contractor_allow_material
 * 
 * @author testor-framework
 * @date 2024-11-26 14:08:48
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_allow_material")
@ApiModel(value = "TContractorAllowMaterial对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAllowMaterial extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 准入id
 */
  @ApiModelProperty(value = "准入id")

  @TableField("allow_id")
  private String allowId;
/**
 * 物料id
 */
  @ApiModelProperty(value = "物料id")
  @TableField("material_id")
  private String materialId;

  @TableField(exist = false)
  private TContractorMaterial tContractorMaterial;


/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;
/**
 * 承包商id
 */
  @ApiModelProperty(value = "承包商id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;

  public static final String ID ="id";
  public static final String ALLOW_ID ="allow_id";
  public static final String MATERIAL_ID ="material_id";
  public static final String BIZ_ID ="biz_id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";


}
