package com.testor.module.contractor.manage.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.testor.module.contractor.manage.model.domain.TContractorBasicInfo;

/**
 * 基本管理 删除参数对象
 *
 * @author testor-framework
 * @date 2024-11-22 21:03:04
 */

@Data
@ApiModel(value = "TContractorBasicInfo 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContractorBasicInfoParam extends TContractorBasicInfo {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "承包商名称")
	private String contractorName;

	@ApiModelProperty(value = "有效期-开始")
	private String validityStartDate;

	@ApiModelProperty(value = "有效期-结束")
	private String validityEndDate;

	@ApiModelProperty(value = "项目ids")
	private List<String> projectIds;

	@ApiModelProperty(value = "待办任务id")
	private String taskId;

	@ApiModelProperty(value = "承包商类别")
	private String type;

	private Map<String, Object> map;
}
