package com.testor.module.hazard.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.accident.model.dto.AccidentReportDetail;
import com.testor.module.accident.template.AccidentReportDetailTemplate;
import com.testor.module.hazard.model.dto.*;
import com.testor.module.hazard.model.template.HazardWorkPlanStatisticsTemplate;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.testor.common.core.enums.BaseStatusEnum;
import com.testor.common.util.BeanConverUtil;
import com.testor.common.util.excel.EasyExcelUtil;
import com.testor.module.hazard.model.template.THazardWorkPlanTemplate;
import com.testor.module.hazard.model.vo.HazardWorkPlanStatisticsVO;
import com.testor.module.hazard.service.HazardWorkPlanStatisticsService;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@RestController
@RequestMapping("/hazard/plan/statistics")
@Api(value = "HazardWorkPlanStatistics", tags = "危险作业统计")
@Slf4j
public class HazardWorkPlanStatisticsController extends SuperController {
    @Autowired
    private HazardWorkPlanStatisticsService hazardWorkPlanStatisticsService;

    @Autowired
    private THazardWorkPlanService tHazardWorkPlanService;

    @GetMapping("/statWorkPlanNumDistribute")
    @ApiOperation(value = "危险作业分布统计")
    public BaseResponse<List<HazardWorkPlanStatisticsVO>> statWorkPlanNumByOrg(HazardWorkPlanStatisticsDto param) {
        BaseResponse<List<HazardWorkPlanStatisticsVO>> response = new BaseResponse<>();
        if(StringHelper.isEmpty(param.getReportStartDate()) || StringHelper.isEmpty(param.getReportEndDate())){
            response.setCode(BaseStatusEnum.UN_DATA.code());
            response.setMsg("请选择作业上报时间");
            return response;
        }
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        List<HazardWorkPlanStatisticsVO> dataList = hazardWorkPlanStatisticsService.statWorkPlanNumByOrg(param);
        response.setData(dataList);
        return response;
    }

    @GetMapping("/statWorkPlanNum")
    @ApiOperation(value = "危险作业数量统计")
    public BaseResponse<List<HazardWorkPlanStatisticsVO>> statWorkPlanNumByTime(HazardWorkPlanStatisticsDto param) {
        BaseResponse<List<HazardWorkPlanStatisticsVO>> response = new BaseResponse<>();
        if(StringHelper.isEmpty(param.getReportStartDate()) || StringHelper.isEmpty(param.getReportEndDate())){
            response.setCode(BaseStatusEnum.UN_DATA.code());
            response.setMsg("请选择作业上报时间");
            return response;
        }
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        List<HazardWorkPlanStatisticsVO> dataList = hazardWorkPlanStatisticsService.statWorkPlanNumByTime(param);
        response.setData(dataList);
        return response;
    }

    @GetMapping("/statStakeholderWorkNum")
    @ApiOperation(value = "相关方作业统计")
    public BaseResponse<List<HazardWorkPlanStatisticsVO>> statStakeholderWorkNum(HazardWorkPlanStatisticsDto param) {
        BaseResponse<List<HazardWorkPlanStatisticsVO>> response = new BaseResponse<>();
        if(StringHelper.isEmpty(param.getReportStartDate()) || StringHelper.isEmpty(param.getReportEndDate())){
            response.setCode(BaseStatusEnum.UN_DATA.code());
            response.setMsg("请选择作业上报时间");
            return response;
        }
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        List<HazardWorkPlanStatisticsVO> dataList = hazardWorkPlanStatisticsService.statStakeholderWorkNum(param);
        response.setData(dataList);
        return response;
    }

    @GetMapping("/statIsRentNum")
    @ApiOperation(value = "租赁库占比统计")
    public BaseResponse<List<HazardWorkPlanStatisticsVO>> statIsRentNum(HazardWorkPlanStatisticsDto param) {
        BaseResponse<List<HazardWorkPlanStatisticsVO>> response = new BaseResponse<>();
        if(StringHelper.isEmpty(param.getReportStartDate()) || StringHelper.isEmpty(param.getReportEndDate())){
            response.setCode(BaseStatusEnum.UN_DATA.code());
            response.setMsg("请选择作业上报时间");
            return response;
        }
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        log.info("租赁库占比统计param:{}", JSON.toJSONString(param));
        List<HazardWorkPlanStatisticsVO> dataList = hazardWorkPlanStatisticsService.statIsRentNum(param);
        response.setData(dataList);
        return response;
    }

    @GetMapping("/statOperatorNum")
    @ApiOperation(value = "危险作业人员统计")
    public BaseResponse<List<HazardWorkPlanStatisticsVO>> statOperatorNum(HazardWorkPlanStatisticsDto param) {
        BaseResponse<List<HazardWorkPlanStatisticsVO>> response = new BaseResponse<>();
        if(StringHelper.isEmpty(param.getReportStartDate()) || StringHelper.isEmpty(param.getReportEndDate())){
            response.setCode(BaseStatusEnum.UN_DATA.code());
            response.setMsg("请选择作业上报时间");
            return response;
        }
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        List<HazardWorkPlanStatisticsVO> dataList = hazardWorkPlanStatisticsService.statOperatorNum(param);
        response.setData(dataList);
        return response;
    }

    @ApiOperation(value = "导出明细", notes = "导出明细")
    @GetMapping(value = "/export")
    public BaseResponse<BizGeneralResponse> export(HttpServletResponse response, HazardWorkPlanStatisticsDto param){
        BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        THazardWorkPlanParam planParam = BeanConverUtil.conver(param, THazardWorkPlanParam.class);
        planParam.setOrgId(null);
        planParam.setStatOrgId(param.getOrgId());
        planParam.setNeWorkStatus("6");
        List<THazardWorkPlanDTO> tHazardWorkPlans = tHazardWorkPlanService.listAllEntity(planParam);
        if (CollectionUtils.isEmpty(tHazardWorkPlans)) {
            baseResponse.setData(BizGeneralResponse.builder().result("无作业计划数据").build());
            return baseResponse;
        }
        List<THazardWorkPlanTemplate> tHazardWorkPlanTemplates = BeanConverUtil.converList(tHazardWorkPlans, THazardWorkPlanTemplate.class);
        int index = 1;
        for(THazardWorkPlanTemplate template : tHazardWorkPlanTemplates){
            template.setNumber(String.valueOf(index++));
        }
        EasyExcelUtil.writeExcel(response, "危险作业计划", "危险作业计划", tHazardWorkPlanTemplates);
        baseResponse.setData(
                BizGeneralResponse.builder().result(TypeHelper.castToString(true)).build());
        return baseResponse;
    }

    @GetMapping("/selectHazardWorkPlanStatistics")
    @ApiOperation(value = "危险作业类型统计分布")
    public BaseResponse<List<THazardWorkPlanStatistics>> selectHazardWorkPlanStatistics(HazardWorkPlanStatisticsDto param) {
        BaseResponse<List<THazardWorkPlanStatistics>> response = new BaseResponse<>();
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        List<THazardWorkPlanStatistics> dataList = hazardWorkPlanStatisticsService.selectHazardWorkPlanStatistics(param);
        response.setData(dataList);
        return response;
    }

    @GetMapping("/selectWorkStatusDetailStatistics")
    @ApiOperation(value = "危险作业详情统计")
    public BaseResponse<BaseResponseList<HazardWorkPlanStatisticsResult>> selectWorkStatusDetailStatistics(HazardWorkPlanStatisticsDto param) {
        BaseResponse<BaseResponseList<HazardWorkPlanStatisticsResult>> response = new BaseResponse<>();
        if(StringHelper.isEmpty(param.getOrgId())){
            param.setOrgId(ContextUtils.getLoginUser().getOrgId());
        }
        BaseResponse<BaseResponseList<HazardWorkPlanStatisticsResult>>baseResponse=new BaseResponse<>();
        Page<HazardWorkPlanStatisticsResult> resultList= hazardWorkPlanStatisticsService.selectWorkStatusDetailStatistics(param);
        BaseResponseList<HazardWorkPlanStatisticsResult> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "导出危险作业详情统计", notes = "导出危险作业详情统计")
    @GetMapping(value = "/selectWorkStatusDetailStatisticsExport")
    public  BaseResponse<BizGeneralResponse> selectWorkStatusDetailStatisticsExport(HttpServletResponse response, HazardWorkPlanStatisticsDto param){
        BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
        List<HazardWorkPlanStatisticsTemplate> hazardWorkPlanStatisticsTemplatePage = hazardWorkPlanStatisticsService.exportCompleteStatistics(param);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(hazardWorkPlanStatisticsTemplatePage)) {
            baseResponse.setData(BizGeneralResponse.builder().result("无危险作业详情数据").build());
            return baseResponse;
        }
        List<HazardWorkPlanStatisticsTemplate> accidentReportDetailTemplate = BeanConverUtil.converList(hazardWorkPlanStatisticsTemplatePage, HazardWorkPlanStatisticsTemplate.class);
        int index = 1;
        for(HazardWorkPlanStatisticsTemplate template : hazardWorkPlanStatisticsTemplatePage){
            template.setNumber(String.valueOf(index++));
        }
        EasyExcelUtil.writeExcel(response, "危险作业详情明细", "危险作业详情明细", accidentReportDetailTemplate);
        baseResponse.setData(
                BizGeneralResponse.builder().result(TypeHelper.castToString(true)).build());
        return baseResponse;
    }

}
