package com.testor.module.hazard.model.domain;

import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 危险作业-超时自动关闭记录表对象 t_hazard_work_plan_expired_log
 *
 * @author testor-framework
 * @date 2025-01-XX
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_work_plan_expired_log")
@ApiModel(value = "THazardWorkPlanExpiredLog对象", description = "危险作业-超时自动关闭记录表")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardWorkPlanExpiredLog extends SuperModel
{
    private static final long serialVersionUID = 1L;

    /** id */
    @ApiModelProperty(value = "id")
    @TableId("id")
    private String id;

    /** 作业id */
    @ApiModelProperty(value = "作业id")
    @TableField("plan_id")
    private String planId;

    /** 作业编码 */
    @ApiModelProperty(value = "作业编码")
    @TableField("code")
    private String code;

    /** 作业类型 */
    @ApiModelProperty(value = "作业类型")
    @TableField("work_type")
    private String workType;

    /** 危险等级 */
    @ApiModelProperty(value = "危险等级")
    @TableField("danger_level")
    private String dangerLevel;

    /** 超时原因 */
    @ApiModelProperty(value = "超时原因")
    @TableField("expired_reason")
    private String expiredReason;

    /** 关闭前状态 */
    @ApiModelProperty(value = "关闭前状态")
    @TableField("before_expiration")
    private String beforeExpiration;

    /** 安全许可申请通过时间 */
    @ApiModelProperty(value = "安全许可申请通过时间")
    @TableField("hazard_license_pass_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date hazardLicensePassTime;

    /** 实际持续小时数 */
    @ApiModelProperty(value = "实际持续小时数")
    @TableField("actual_duration_hours")
    private BigDecimal actualDurationHours;


    /** 作业创建时间 */
    @ApiModelProperty(value = "作业创建时间")
    @TableField("plan_create_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date planCreateDate;


    // 常量定义
    public static final String ID = "id";
    public static final String PLAN_ID = "plan_id";
    public static final String CODE = "code";
    public static final String WORK_TYPE = "work_type";
    public static final String DANGER_LEVEL = "danger_level";
    public static final String EXPIRED_REASON = "expired_reason";
    public static final String BEFORE_EXPIRATION = "before_expiration";
    public static final String HAZARD_LICENSE_PASS_TIME = "hazard_license_pass_time";
    public static final String ACTUAL_DURATION_HOURS = "actual_duration_hours";
    public static final String PLAN_CREATE_DATE = "plan_create_date";
}