package com.testor.module.messageNotice.controller;

import com.testor.common.util.cron.FrequencyDTO;
import com.testor.common.util.cron.FrequencyUtil;
import com.testor.module.messageNotice.model.domain.TSysMsgRemindConf;
import com.testor.module.messageNotice.model.dto.TSysMsgRemindConfDelParam;
import com.testor.module.messageNotice.model.dto.TSysMsgRemindConfParam;
import com.testor.module.messageNotice.service.TSysMsgRemindConfService;
import com.testor.module.safeCheck.service.HazardCheckTaskService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 功能配置-消息提醒配置Controller
 *
 * @author testor-framework
 * @date 2022-08-19 16:56:31
 */
@RestController
@RequestMapping("/module/conf")
@Api(value = "TSysMsgRemindConf", tags = "功能配置-消息提醒配置")
@Slf4j
public class TSysMsgRemindConfController extends SuperController
{
    @Autowired
    private TSysMsgRemindConfService tSysMsgRemindConfService;

    @Autowired
    private HazardCheckTaskService hazardCheckTaskService;

    @Resource
	private FrequencyUtil frequencyUtil;

    /* Generated Method*/
	@ApiOperation(value = "新增 功能配置-消息提醒配置", notes = "Add TSysMsgRemindConf")
	@PostMapping(value = "/add")
	public BaseResponse<TSysMsgRemindConf>addEntity(@RequestBody TSysMsgRemindConf addRequest) {
		BaseResponse<TSysMsgRemindConf> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
            TSysMsgRemindConf data=BeanHelper.beanToBean(addRequest,  TSysMsgRemindConf.class);

            FrequencyDTO frequencyDTO = new FrequencyDTO();
			frequencyDTO.setFrequencyKey(data.getFrequencyKey());
			frequencyDTO.setSecond(0);
			frequencyDTO.setMinute(0);
			frequencyDTO.setTime("00:00:00");
			String cronStr = frequencyUtil.generateCronByNoAdvance(frequencyDTO);
			data.setCronExpression(cronStr);

            boolean result= tSysMsgRemindConfService.save(data);
			if(result){
				baseResponse.setData(data);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 功能配置-消息提醒配置 ", notes = "Get TSysMsgRemindConf By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSysMsgRemindConf> getById(String id){
		BaseResponse<TSysMsgRemindConf> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TSysMsgRemindConf data= tSysMsgRemindConfService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 功能配置-消息提醒配置 ", notes = "Update TSysMsgRemindConf By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSysMsgRemindConf updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
            TSysMsgRemindConf data=BeanHelper.beanToBean(updateRequest, TSysMsgRemindConf.class);

			FrequencyDTO frequencyDTO = new FrequencyDTO();
			frequencyDTO.setFrequencyKey(data.getFrequencyKey());
			frequencyDTO.setSecond(0);
			frequencyDTO.setMinute(0);
			frequencyDTO.setTime("00:00:00");
			String cronStr = frequencyUtil.generateCronByNoAdvance(frequencyDTO);
			data.setCronExpression(cronStr);

            boolean result= tSysMsgRemindConfService.updateById(data);
			if(result) { // 消息提醒配置发生变动，重新设置 巡检任务即将逾期处理 job
				hazardCheckTaskService.handleNearOverdueJobByCof();
			}
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 功能配置-消息提醒配置 ", notes = "delete TSysMsgRemindConf By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSysMsgRemindConfDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSysMsgRemindConf data= new TSysMsgRemindConf();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSysMsgRemindConfService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除功能配置-消息提醒配置", notes = "delete TSysMsgRemindConf by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSysMsgRemindConfDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSysMsgRemindConf> tSysMsgRemindConfList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSysMsgRemindConf data= new TSysMsgRemindConf();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSysMsgRemindConfList.add(data);
			}
			boolean result = tSysMsgRemindConfService.updateBatchById(tSysMsgRemindConfList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 功能配置-消息提醒配置 分页列表", notes = "List TSysMsgRemindConf with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSysMsgRemindConf>>listEntity(TSysMsgRemindConfParam param){
		BaseResponse<BaseResponseList<TSysMsgRemindConf>>baseResponse=new BaseResponse<>();

		BaseResponseList<TSysMsgRemindConf> resultList= tSysMsgRemindConfService.listEntity(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 功能配置-消息提醒配置 列表", notes = "List TSysMsgRemindConf all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSysMsgRemindConf>>listAllEntity(TSysMsgRemindConfParam param){
		BaseResponse<BaseResponseList<TSysMsgRemindConf>>baseResponse=new BaseResponse<>();

		List<TSysMsgRemindConf> resultList=tSysMsgRemindConfService.listAllEntity(param);
		BaseResponseList<TSysMsgRemindConf> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

}
