package com.testor.module.notice.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;


/**
 * notice对象 t_sys_notice
 * 
 * @author tong-framework
 * @date 2022-04-27 18:10:12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_notice")
@ApiModel(value = "TSysNotice对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysNotice extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 公告id
 */
  @ApiModelProperty(value = "公告id" , required = true)

  @TableId("id")
  private String id;
  /**
   * 发布单位
   */
  @ApiModelProperty(value = "发布单位")

  @TableField("release_unit")
  private String releaseUnit;

  /**
   * 发布单位所属组织机构层级
   */
  @ApiModelProperty(value = "发布单位所属组织机构层级")

  @TableField("\"level\"")
  private BigDecimal level;
  
/**
 * 公告标题
 */
  @ApiModelProperty(value = "公告标题" ,required = true)

  @TableField("title")
  private String title;
/**
 * 公告内容
 */
  @ApiModelProperty(value = "公告内容",required = true)

  @TableField("content")
  private String content;
/**
 * 接收对象
 */
  @ApiModelProperty(value = "接收对象" , required = true)

  @TableField("receiver_obj")
  private String receiverObj;

  /**
   * 用于回显字段
   */
  @ApiModelProperty(value = "用于回显字段" , required = true)

  @TableField("accept_obj")
  private String acceptObj;
/**
 * 关联附件id
 */
  @ApiModelProperty(value = "关联附件id")

  @TableField("ref_id")
  private String refId;
/**
 * 驳回意见
 */
  @ApiModelProperty(value = "驳回意见")

  @TableField("reject_opinion")
  private String rejectOpinion;
  @ApiModelProperty(value = "组织结构id")
  @TableField("org_id")
  private String orgId;
///**
// * 状态 0 未读 1 已读
// */
//  @ApiModelProperty(value = "状态 0 未读 1 已读")
//
//  @TableField("is_read")
  private String isRead;

/**
 * 父级id
 */
  @ApiModelProperty(value = "父级id")

  @TableField("parent_id")
  private String parentId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例id
 */
  @ApiModelProperty(value = "流程实例id")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态  3 提交（待审核）4 草稿 5 审核通过 6 撤销发布 7 驳回（审核失败）")

  @TableField("process_status")
  private String processStatus;

  /**
   * 审核通过发布时间
   */
  @ApiModelProperty(value = "审核通过发布时间")

  @TableField("release_time")
  private Date releaseTime;

  /**
   * 接收对象类型
   */
  @ApiModelProperty(value = "接收对象类型")
  @TableField("receiver_type")
  private String receiverType;

  @TableField(exist = false)
  private String type;

  @ApiModelProperty(value = "是否置顶 0置顶 1未置顶")
  @TableField(exist = false)
  private Integer top = 1;

  @TableField(exist = false)
  private String userOrgId;


  public static final String ID ="id";
  public static final String TITLE ="title";
  public static final String CONTENT ="content";
  public static final String LEVEL ="\"level\"";
  public static final String RECEIVER_OBJ ="receiver_obj";
  public static final String RELEASE_UNIT = "release_unit";
  public static final String REF_ID ="ref_id";
  public static final String REJECT_OPINION ="reject_opinion";
  public static final String IS_READ ="is_read";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
//  public static final String AUDIT = "audit";


}
