package com.testor.module.partner.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.testor.module.partner.model.domain.TJobStatistics;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;


/**
 * 现场作业统计 删除参数对象
 *
 * @author testor-framework
 * @date 2022-11-02 10:42:06
 */

@Data
@ApiModel(value = "TJobStatistics 列表查询参数对象")
public class TJobStatisticsParam     {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "开始时间")
	private String zykssj;

	@ApiModelProperty(value = "结束时间")
	private String zyjssj;

	@ApiModelProperty(value = "接收数据")
	private List<TJobStatistics> data;

	@ApiModelProperty(value = "批量ID")
	private List<String> ids;

	@ApiModelProperty(value = "区域公司id")
	private String areaId;

	@ApiModelProperty(value = "粮库id")
	private String grainDepotId;

	@ApiModelProperty(value = "标识")
	private String flag;

	@ApiModelProperty(value = "级别")
	private String treeLevel;

	private Boolean add=true;

	@ApiModelProperty(value = "作业状态")
	private String dhzyZyzt;
	/**
	 * 单位名称
	 */
	@ApiModelProperty(value = "单位名称")
	private String dhzyGcmz;
	/**
	 * 租赁单位
	 */
	@ApiModelProperty(value = "租赁单位")
	private String dhzyZksspry;
	/**
	 * 是否为租赁单位
	 */
	@ApiModelProperty(value = "是否为租赁单位")
	private String sfzyk;
	/**
	 * 相关方单位作业人数
	 */
	@ApiModelProperty(value = "相关方单位作业人数" , example = "0")
	private Long xgfdwry;
	/**
	 * 作业结束时间
	 */
	@ApiModelProperty(value = "作业结束时间")
	private String dhzyZyjssj;
	/**
	 * 作业开始时间
	 */
	@ApiModelProperty(value = "作业开始时间")
	private String dhzyZykssj;
	/**
	 * 作业类型
	 */
	@ApiModelProperty(value = "作业类型")
	private String dhzyZylb;
	/**
	 * 图案数据唯一标识
	 */
	@ApiModelProperty(value = "图案数据唯一标识")
	private String dhzyId;
	/**
	 * 父级id
	 */
	@ApiModelProperty(value = "父级id")
	private String parentId;
	/**
	 * id
	 */
	@ApiModelProperty(value = "id")
	private String id;
	/**
	 * 组织机构id
	 */
	@ApiModelProperty(value = "组织机构id")
	private String orgId;
	/**
	 * 公司code值
	 */
	@ApiModelProperty(value = "公司code值")
	private String code;
	/**
	 *所有父级机构主键以英文逗号隔开如：一级，二级等
	 */
	@ApiModelProperty(value = "所有父级机构主键以英文逗号隔开如：一级，二级等")
	private String orgAllPath;

	@ApiModelProperty(value = "批量ID")
	private List<String> orgIds;


}
