package com.testor.module.train.project.model.stat;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author caq
 * @date 2024/9/7
 * @description 个人档案详情
 */
@Data
public class TrainProjectUserDetailStat {
    @ApiModelProperty(value = "id")
    private String id;
    @ApiModelProperty(value = "考试名称，培训名称")
    private String taskName;
    @ApiModelProperty(value = "线上线下")
    private String learnWay;
    @ApiModelProperty(value = "人员id")
    private String personId;
    @ApiModelProperty(value = "人员类型")
    private String userTypeCode;
    private String userTypeName;
    private String orgName;
    private String orgId;
    private String tabStatus;


    @ApiModelProperty(value = "计划开始时间")

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date visitStartTime;

    @ApiModelProperty(value = "计划结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date visitEndTime;


    @ApiModelProperty(value = "考试成绩")
    private String testScore;
    @ApiModelProperty(value = "考试时长")
    private String examDuration;

    @ApiModelProperty(value = "考试地点")
    private String examSite;

    @ApiModelProperty(value = "补考成绩")
    private String repairTest;


    @ApiModelProperty(value = "是否是外部培训数据“ 1 是，0.否”")
    private String externalDataStatus;


}
