package com.testor.module.train.project.service;

import com.testor.module.train.project.model.stat.ProjectStatTotalVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author caq
 * @date 2024/9/5
 * @description 教育培训计划-总体看板
 */
public interface TrainProjectStatisticsAllService {

    /**
     * 查询 培训计划数 ，应学人数，完成人数，完成率 培训时长
     * @param orgId
     * @param startTime
     * @param endTime
     * @return
     */
    ProjectStatTotalVo findProjectNumTotal(String orgId, String startTime, String endTime,   String projectId);

    /**
     *   查询 培训计划数 分大区和角色
     * @param orgId
     * @param startTime
     * @param endTime
     * @param type
     * @return
     */
    List<ProjectStatTotalVo> findProjectNumByOrgOrVisitType(String orgId, String startTime, String endTime, String type);

    /**
     *   查询 培训人员数 分大区和角色
     * @param orgId
     * @param startTime
     * @param endTime
     * @param type
     * @return
     */
    List<ProjectStatTotalVo> findPersonNumByOrgOrVisitType(String orgId, String startTime, String endTime, String type);

    /**
     *   查询 培训学时数 分大区和角色
     * @param orgId
     * @param startTime
     * @param endTime
     * @param type
     * @return
     */
    List<ProjectStatTotalVo> findTrainTimeByOrgOrVisitType(String orgId, String startTime, String endTime, String type);

    /**
     * 查询培训评价统计
     * @param orgId
     * @param startTime
     * @param endTime
     * @return
     */
    ProjectStatTotalVo findTrainEvaluateStat(String orgId, String startTime, String endTime, String projectId);


    /**
     * 查询 培训类型人数 统计
     * @param orgId
     * @param startTime
     * @param endTime
     * @return
     */
    List<ProjectStatTotalVo> findTrainTypeStat(String orgId, String startTime, String endTime);


}