package com.testor.module.video.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.video.model.domain.TVideoEquipmentInfo;
import com.testor.module.video.model.dto.TVideoEquipmentInfoParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import com.tongtech.tfw.workflow.apis.task.model.dto.CompleteTask;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 视频监控——设备信息Service接口
 * 
 * @author testor-framework
 * @date 2022-11-18 11:41:23
 */
public interface TVideoEquipmentInfoService extends SuperService<TVideoEquipmentInfo> {

    BaseResponse imports(MultipartFile file) throws BusinessException;

    void downloadWorkareaTemplate(HttpServletResponse response, String fileDowName, String curUserOrgId);

    IPage<TVideoEquipmentInfo> myList(Page<TVideoEquipmentInfo> resultPage, TVideoEquipmentInfoParam param);

    /**
     * @description TODO 设备导入模板下载
     * @param request
     * @param response
     * @param orgId
     * @return void
     * @author qiao
     * @date 4/6/23 3:06 PM
     */
    void getTemplate(HttpServletRequest request, HttpServletResponse response, String orgId);

    void completeTask(CompleteTask completeTask);
}
